    SECTION code_driver

    PUBLIC  asm_circle


    GLOBAL  __tempx_s
    GLOBAL  __tempy_s
    GLOBAL  __templ_d
    GLOBAL  __fillstyle
    GLOBAL  __fgcolour
    GLOBAL  __bgcolour
    GLOBAL  asm_line
    GLOBAL  asm_plot


	;; Draw a circle from (B,C) with radius D
asm_circle:
	LD	A,B	;Store center values
	LD	(__tempx_s),A
	LD	A,C
	LD	(__tempy_s),A

	XOR	A
	LD	(__tempx_s+1),A 
	LD	A,D
	LD	(__tempy_s+1),A 
	CPL
	LD	L,A
	LD	H,0xFF
	INC	HL
	LD	BC,0
	ADD	HL,BC
	LD	A,L
	LD	(__templ_d+1),A
	LD	A,H
	LD	(__templ_d),A

cloop:
	LD	A,(__tempx_s+1)
	LD	B,A
	LD	A,(__tempy_s+1)
	SUB	B
	RET	C

	LD	A,(__fillstyle)
	OR	A
	CALL	Z,__circplot

	LD	A,(__templ_d)
	BIT	7,A
	JR	Z,ycirc

	LD	A,(__fillstyle)
	OR	A
	CALL	NZ,horlin
	LD	A,(__tempx_s+1)
	INC	A
	LD	(__tempx_s+1),A
	LD	A,(__templ_d)
	LD	B,A
	LD	A,(__templ_d+1)
	LD	C,A
	LD	H,0
	LD	A,(__tempx_s+1)
	LD	L,A
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,BC
	LD	BC,6
	ADD	HL,BC
	LD	A,H
	LD	(__templ_d),A
	LD	A,L
	LD	(__templ_d+1),A
	JR	cloop
ycirc:	
	LD	A,(__fillstyle)
	OR	A
	CALL	NZ,verlin
	LD	A,(__tempx_s+1)
	INC	A
	LD	(__tempx_s+1),A
	LD	B,0
	LD	A,(__tempx_s+1)
	LD	C,A
	LD	H,0xFF
	LD	A,(__tempy_s+1)
	CPL
	LD	L,A
	INC	HL
	ADD	HL,BC
	LD	A,(__templ_d)
	LD	B,A
	LD	A,(__templ_d+1)
	LD	C,A
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,BC
	LD	BC,10
	ADD	HL,BC
	LD	A,H
	LD	(__templ_d),A
	LD	A,L
	LD	(__templ_d+1),A
	LD	A,(__tempy_s+1)
	DEC	A
	LD	(__tempy_s+1),A
	JP	cloop

horlin:
	LD	A,(__tempx_s)
	LD	B,A
	LD	A,(__tempy_s)
	LD	C,A
	LD	A,(__tempx_s+1)
	LD	D,A
	LD	A,(__tempy_s+1)
	LD	E,A
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	H,A
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	ADD	D
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	LD	A,D
	OR	A
	RET	Z
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	H,A
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	SUB	D
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	RET

verlin:
	LD	A,(__tempx_s)
	LD	B,A
	LD	A,(__tempy_s)
	LD	C,A
	LD	A,(__tempx_s+1)
	LD	D,A
	LD	A,(__tempy_s+1)
	LD	E,A
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	H,A
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	ADD	D
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	H,A
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	SUB	D
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	LD	A,D
	SUB	E
	RET	Z
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	D
	LD	H,A
	LD	A,B
	ADD	D
	LD	B,A
	LD	A,C
	SUB	E
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	D
	LD	H,A
	LD	A,B
	ADD	D
	LD	B,A
	LD	A,C
	ADD	E
	LD	C,A
	LD	D,H
	LD	E,C
	CALL	asm_line
	POP	DE
	POP	BC
	RET

__circplot:
	LD	A,(__tempx_s)
	LD	B,A
	LD	A,(__tempy_s)
	LD	C,A
	LD	A,(__tempx_s+1)
	LD	D,A
	LD	A,(__tempy_s+1)
	LD	E,A
	PUSH	BC
	PUSH	DE
	LD	A,B
	ADD	D
	LD	B,A
	LD	A,C
	SUB	E
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	B,A
	LD	A,C
	SUB	D
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	D
	LD	B,A
	LD	A,C
	ADD	E
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	ADD	D
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	
	LD	A,D
	OR	A
	RET	Z
	SUB	E
	RET	Z

	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	D
	LD	B,A
	LD	A,C
	SUB	E
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	SUB	E
	LD	B,A
	LD	A,C
	ADD	D
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	ADD	D
	LD	B,A
	LD	A,C
	ADD	E
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	PUSH	BC
	PUSH	DE
	LD	A,B
	ADD	E
	LD	B,A
	LD	A,C
	SUB	D
	LD	C,A
	CALL	asm_plot
	POP	DE
	POP	BC
	RET
